/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.hibiscus.naturespirit.NatureSpirit;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;

public class TerraFlavaParameters
extends class_6554 {
    private final class_6544.class_6546 defaultParameter = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    private final class_6544.class_6546[] temperatureParameters = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f), class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f), class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f), class_6544.class_6546.method_38121((float)0.2f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    private final class_6544.class_6546[] humidityParameters = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f), class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f), class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f), class_6544.class_6546.method_38121((float)0.1f, (float)0.3f), class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)};
    private final class_6544.class_6546[] erosionParameters = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f), class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f), class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f), class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f), class_6544.class_6546.method_38121((float)0.05f, (float)0.45f), class_6544.class_6546.method_38121((float)0.45f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    private final class_6544.class_6546 frozenTemperature;
    private final class_6544.class_6546 nonFrozenTemperatureParameters;
    private final class_6544.class_6546 mushroomFieldsContinentalness;
    private final class_6544.class_6546 deepOceanContinentalness;
    private final class_6544.class_6546 oceanContinentalness;
    private final class_6544.class_6546 coastContinentalness;
    private final class_6544.class_6546 riverContinentalness;
    private final class_6544.class_6546 nearInlandContinentalness;
    private final class_6544.class_6546 midInlandContinentalness;
    private final class_6544.class_6546 farInlandContinentalness;
    private final class_5321<class_1959>[][] oceanBiomes;
    private final class_5321<class_1959>[][] commonBiomes;
    private final class_5321<class_1959>[][] uncommonBiomes;
    private final class_5321<class_1959>[][] nearMountainBiomes;
    private final class_5321<class_1959>[][] specialNearMountainBiomes;
    private final class_5321<class_1959>[][] windsweptBiomes;
    class_5321<class_1959> commonBiomePlainsCold;
    class_5321<class_1959> mountainBiomeMeadowCold;
    class_5321<class_1959> mountainBiomeForestCold;
    class_5321<class_1959> mountainBiomeMeadowCold2;
    class_5321<class_1959> uncommonBiomeCold;
    class_5321<class_1959> commonBiomeForestCold;
    class_5321<class_1959> commonBiomeTaigaCold;
    class_5321<class_1959> commonBiomeOldSpruceCold;
    class_5321<class_1959> uncommonBiomeOldPineCold;
    class_5321<class_1959> commonBiomeDesertHot;
    class_5321<class_1959> commonBiomeDesertHot2;
    class_5321<class_1959> commonBiomeSavannaWarm;
    class_5321<class_1959> commonBiomeForestWarm;
    class_5321<class_1959> nearBiomeSavannaPlateauWarm;
    class_5321<class_1959> nearBiomeBadlandsHot;
    class_5321<class_1959> nearBiomeWoodedBadlandsHot;
    class_5321<class_1959> nearBiomeBadlandsHot2;
    class_5321<class_1959> specialBiomeErodedBadlandsHot;

    public TerraFlavaParameters() {
        this.commonBiomePlainsCold = NatureSpirit.CONFIG.has_golden_wilds ? NSBiomes.GOLDEN_WILDS : class_1972.field_9451;
        this.mountainBiomeMeadowCold = NatureSpirit.CONFIG.has_golden_wilds ? NSBiomes.GOLDEN_WILDS : class_1972.field_34470;
        class_5321 class_53212 = this.mountainBiomeForestCold = NatureSpirit.CONFIG.has_golden_wilds ? NSBiomes.GOLDEN_WILDS : class_1972.field_9409;
        this.mountainBiomeMeadowCold2 = NatureSpirit.CONFIG.has_marigold_meadows ? NSBiomes.MARIGOLD_MEADOWS : (NatureSpirit.CONFIG.has_golden_wilds ? NSBiomes.GOLDEN_WILDS : class_1972.field_34470);
        this.uncommonBiomeCold = NatureSpirit.CONFIG.has_marigold_meadows ? NSBiomes.MARIGOLD_MEADOWS : null;
        this.commonBiomeForestCold = NatureSpirit.CONFIG.has_maple_woodlands ? NSBiomes.MAPLE_WOODLANDS : class_1972.field_9409;
        this.commonBiomeTaigaCold = NatureSpirit.CONFIG.has_aspen_forest ? NSBiomes.ASPEN_FOREST : class_1972.field_9420;
        this.commonBiomeOldSpruceCold = NatureSpirit.CONFIG.has_aspen_forest ? NSBiomes.ASPEN_FOREST : class_1972.field_35113;
        this.uncommonBiomeOldPineCold = NatureSpirit.CONFIG.has_aspen_forest ? null : class_1972.field_35119;
        this.commonBiomeDesertHot = NatureSpirit.CONFIG.has_drylands ? NSBiomes.DRYLANDS : class_1972.field_9424;
        this.commonBiomeDesertHot2 = NatureSpirit.CONFIG.has_wooded_drylands ? NSBiomes.WOODED_DRYLANDS : class_1972.field_9424;
        this.commonBiomeSavannaWarm = NatureSpirit.CONFIG.has_wooded_drylands ? NSBiomes.WOODED_DRYLANDS : class_1972.field_9449;
        this.commonBiomeForestWarm = NatureSpirit.CONFIG.has_wooded_drylands ? NSBiomes.WOODED_DRYLANDS : class_1972.field_9409;
        this.nearBiomeSavannaPlateauWarm = NatureSpirit.CONFIG.has_wooded_drylands ? NSBiomes.WOODED_DRYLANDS : class_1972.field_9430;
        this.nearBiomeBadlandsHot = NatureSpirit.CONFIG.has_drylands ? NSBiomes.DRYLANDS : class_1972.field_9415;
        this.nearBiomeWoodedBadlandsHot = NatureSpirit.CONFIG.has_wooded_drylands ? NSBiomes.WOODED_DRYLANDS : class_1972.field_35110;
        this.nearBiomeBadlandsHot2 = NatureSpirit.CONFIG.has_wooded_drylands ? NSBiomes.WOODED_DRYLANDS : class_1972.field_9415;
        this.specialBiomeErodedBadlandsHot = NatureSpirit.CONFIG.has_drylands ? null : class_1972.field_9443;
        this.frozenTemperature = this.temperatureParameters[0];
        this.nonFrozenTemperatureParameters = class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[1], (class_6544.class_6546)this.temperatureParameters[4]);
        this.mushroomFieldsContinentalness = class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f);
        this.deepOceanContinentalness = class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f);
        this.oceanContinentalness = class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f);
        this.coastContinentalness = class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f);
        this.riverContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f);
        this.nearInlandContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f);
        this.midInlandContinentalness = class_6544.class_6546.method_38121((float)0.03f, (float)0.3f);
        this.farInlandContinentalness = class_6544.class_6546.method_38121((float)0.3f, (float)1.0f);
        this.oceanBiomes = new class_5321[][]{{class_1972.field_9418, class_1972.field_9470, class_1972.field_9446, class_1972.field_9439, class_1972.field_9408}, {class_1972.field_9435, class_1972.field_9467, class_1972.field_9423, class_1972.field_9441, class_1972.field_9408}};
        this.commonBiomes = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9420}, {this.commonBiomePlainsCold, this.commonBiomePlainsCold, this.commonBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {class_1972.field_9414, class_1972.field_9451, class_1972.field_9409, class_1972.field_9412, class_1972.field_9475}, {this.commonBiomeSavannaWarm, this.commonBiomeSavannaWarm, this.commonBiomeForestWarm, class_1972.field_9417, class_1972.field_9417}, {this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot2}};
        this.uncommonBiomes = new class_5321[][]{{class_1972.field_9453, null, class_1972.field_9454, null, null}, {this.uncommonBiomeCold, null, null, null, this.uncommonBiomeOldPineCold}, {class_1972.field_9455, null, null, class_1972.field_35112, null}, {null, null, null, class_1972.field_35118, null}, {null, null, null, null, null}};
        this.nearMountainBiomes = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9454}, {this.mountainBiomeMeadowCold2, this.mountainBiomeMeadowCold, this.mountainBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_9475}, {this.nearBiomeSavannaPlateauWarm, this.nearBiomeSavannaPlateauWarm, this.commonBiomeForestWarm, class_1972.field_9409, class_1972.field_9417}, {this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot2, this.nearBiomeWoodedBadlandsHot, this.nearBiomeWoodedBadlandsHot}};
        this.specialNearMountainBiomes = new class_5321[][]{{class_1972.field_9453, null, null, null, null}, {null, this.uncommonBiomeCold, null, null, this.uncommonBiomeOldPineCold}, {class_1972.field_42720, class_1972.field_42720, class_1972.field_9409, class_1972.field_9412, null}, {null, null, null, null, null}, {this.specialBiomeErodedBadlandsHot, this.specialBiomeErodedBadlandsHot, null, null, null}};
        this.windsweptBiomes = new class_5321[][]{{class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35116, class_1972.field_35116, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {null, null, null, null, null}, {null, null, null, null, null}};
    }

    protected void method_38185(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.writeOceanBiomes(parameters);
        this.writeLandBiomes(parameters);
        this.method_38199(parameters);
    }

    private void writeOceanBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.writeBiomeParameters(parameters, this.defaultParameter, this.defaultParameter, this.mushroomFieldsContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, (class_5321<class_1959>)class_1972.field_9462);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            this.writeBiomeParameters(parameters, parameterRange, this.defaultParameter, this.deepOceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[0][i]);
            this.writeBiomeParameters(parameters, parameterRange, this.defaultParameter, this.oceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[1][i]);
        }
    }

    private void writeLandBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.93333334f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)-0.93333334f, (float)-0.7666667f));
        this.writePeakBiomes(parameters, class_6544.class_6546.method_38121((float)-0.7666667f, (float)-0.56666666f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)-0.56666666f, (float)-0.4f));
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)-0.4f, (float)-0.26666668f));
        this.writeLowBiomes(parameters, class_6544.class_6546.method_38121((float)-0.26666668f, (float)-0.05f));
        this.writeValleyBiomes(parameters, class_6544.class_6546.method_38121((float)-0.05f, (float)0.05f));
        this.writeLowBiomes(parameters, class_6544.class_6546.method_38121((float)0.05f, (float)0.26666668f));
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)0.26666668f, (float)0.4f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)0.4f, (float)0.56666666f));
        this.writePeakBiomes(parameters, class_6544.class_6546.method_38121((float)0.56666666f, (float)0.7666667f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)0.7666667f, (float)0.93333334f));
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)0.93333334f, (float)1.0f));
    }

    private void writePeakBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getWoodedDrylandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getNearMountainBiome(i, j, weirdness);
                class_5321<class_1959> registryKey5 = this.getWindsweptOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey6 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey5);
                class_5321<class_1959> registryKey7 = this.getPeakBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NatureSpirit.CONFIG.has_drylands ? registryKey2 : registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeHighBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getWoodedDrylandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getNearMountainBiome(i, j, weirdness);
                class_5321<class_1959> registryKey5 = this.getWindsweptOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey6 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey);
                class_5321<class_1959> registryKey7 = this.getMountainSlopeBiome(i, j, weirdness);
                class_5321<class_1959> registryKey8 = this.getPeakBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey8);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeMidBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[2]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9419);
        this.writeBiomeParameters(parameters, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[1], (class_6544.class_6546)this.temperatureParameters[2]), this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9471);
        this.writeBiomeParameters(parameters, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[3], (class_6544.class_6546)this.temperatureParameters[4]), this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_38748);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getBadlandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getWindsweptOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey5 = this.getNearMountainBiome(i, j, weirdness);
                class_5321<class_1959> registryKey6 = this.getShoreBiome(i, j);
                class_5321<class_1959> registryKey7 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey);
                class_5321<class_1959> registryKey8 = this.getErodedShoreBiome(i, j, weirdness);
                class_5321<class_1959> registryKey9 = this.getMountainSlopeBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey9);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.midInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, i == 0 ? registryKey9 : registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, NatureSpirit.CONFIG.has_drylands ? registryKey : registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, NatureSpirit.CONFIG.has_drylands ? registryKey : registryKey2);
                if (weirdness.comp_104() < 0L) {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey6);
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                } else {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                }
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey8);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey4);
                if (weirdness.comp_104() < 0L) {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey6);
                } else {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey);
                }
                if (i != 0) continue;
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeLowBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[2]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9419);
        this.writeBiomeParameters(parameters, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[1], (class_6544.class_6546)this.temperatureParameters[2]), this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9471);
        this.writeBiomeParameters(parameters, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[3], (class_6544.class_6546)this.temperatureParameters[4]), this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_38748);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getBadlandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getShoreBiome(i, j);
                class_5321<class_1959> registryKey5 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey);
                class_5321<class_1959> registryKey6 = this.getErodedShoreBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, NatureSpirit.CONFIG.has_drylands ? registryKey : registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, NatureSpirit.CONFIG.has_drylands ? registryKey : registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[3], (class_6544.class_6546)this.erosionParameters[4]), weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey4);
                if (i != 0) continue;
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeValleyBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)(weirdness.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9463));
        this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)(weirdness.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9438));
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[5]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[5]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        this.writeBiomeParameters(parameters, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[1], (class_6544.class_6546)this.temperatureParameters[2]), this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.riverContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9471);
        this.writeBiomeParameters(parameters, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[3], (class_6544.class_6546)this.temperatureParameters[4]), this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.riverContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_38748);
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.riverContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = NatureSpirit.CONFIG.has_drylands ? this.getRegularBiome(i, j, weirdness) : this.getBadlandsOrRegularBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
            }
        }
    }

    private class_5321<class_1959> getRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            return this.commonBiomes[temperature][humidity];
        }
        class_5321<class_1959> registryKey = this.uncommonBiomes[temperature][humidity];
        return registryKey == null ? this.commonBiomes[temperature][humidity] : registryKey;
    }

    private class_5321<class_1959> getMountainStartBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        return temperature == 0 ? this.getMountainSlopeBiome(temperature, humidity, weirdness) : this.getRegularBiome(temperature, humidity, weirdness);
    }

    private class_5321<class_1959> getBiomeOrWindsweptSavanna(int temperature, int humidity, class_6544.class_6546 weirdness, class_5321<class_1959> biomeKey) {
        return temperature > 1 && humidity < 4 && weirdness.comp_104() >= 0L ? class_1972.field_35114 : biomeKey;
    }

    private class_5321<class_1959> getWoodedDrylandsOrRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        return temperature == 4 ? NSBiomes.WOODED_DRYLANDS : this.getRegularBiome(temperature, humidity, weirdness);
    }

    private class_5321<class_1959> getBadlandsBiome(int humidity, class_6544.class_6546 weirdness) {
        if (humidity < 2) {
            return weirdness.comp_104() < 0L ? class_1972.field_9415 : class_1972.field_9443;
        }
        return humidity < 3 ? class_1972.field_9415 : class_1972.field_35110;
    }

    private class_5321<class_1959> getBadlandsOrRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        return temperature == 4 ? this.getBadlandsBiome(humidity, weirdness) : this.getRegularBiome(temperature, humidity, weirdness);
    }

    private class_5321<class_1959> getErodedShoreBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> registryKey = weirdness.comp_104() >= 0L ? this.getRegularBiome(temperature, humidity, weirdness) : this.getShoreBiome(temperature, humidity);
        return this.getBiomeOrWindsweptSavanna(temperature, humidity, weirdness, registryKey);
    }

    private class_5321<class_1959> getShoreBiome(int temperature, int humidity) {
        if (temperature == 0) {
            return class_1972.field_9478;
        }
        if (temperature == 3 && NatureSpirit.CONFIG.has_tropical_shores) {
            return NSBiomes.TROPICAL_SHORES;
        }
        return temperature == 4 ? (NatureSpirit.CONFIG.has_drylands ? NSBiomes.DRYLANDS : class_1972.field_9424) : class_1972.field_9434;
    }

    private class_5321<class_1959> getNearMountainBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> registryKey;
        if (weirdness.comp_104() >= 0L && (registryKey = this.specialNearMountainBiomes[temperature][humidity]) != null) {
            return registryKey;
        }
        return this.nearMountainBiomes[temperature][humidity];
    }

    private class_5321<class_1959> getPeakBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature <= 2) {
            return weirdness.comp_104() < 0L ? class_1972.field_34474 : class_1972.field_35115;
        }
        return class_1972.field_34475;
    }

    private class_5321<class_1959> getMountainSlopeBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature >= 3) {
            return this.getNearMountainBiome(temperature, humidity, weirdness);
        }
        return humidity <= 1 ? class_1972.field_34472 : class_1972.field_34471;
    }

    private class_5321<class_1959> getWindsweptOrRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> registryKey = this.windsweptBiomes[temperature][humidity];
        return registryKey == null ? this.getRegularBiome(temperature, humidity, weirdness) : registryKey;
    }

    private void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }
}

